	function [L, C, K] = X_FOSTER_II(Xnum, Xden)
	
	% 	Computes the element values in a Foster II realization of the suceptance of Y(s). 
	%	The resulting network is a parallel combination of reactances of series 
	%	resonance circuits. Reactance #1 is a parallel resonace circuit.
	%
	%	Y(s) = C1s + L1/s + a2s/(s^2+w2^2) + a3s/(s^2+w3^2)+....
	%	Ln = an/wn^2 and Cn = 1/an
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2007-06-25
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
 
	% 	Example: 	Xnum =   [6 0 121 0 394 0  9];  Xden = [2 0 40 0 128 0]; yeilds
	%				Y(s) = 3s+ 0.0703125/s + 0.15625 s/(s^2+4) + 0.2734375 s/(s^2+16)
	
	% Check if the reactance is a valid reactance
	if abs(length(Xnum)-length(Xden)) ~= 1
		disp(['Invalid reactance!'])
		% Add more checks
	end

	n = max(length(Xnum),length(Xden));
	C = zeros(1,(n-1)/2);
	L = zeros(1,(n-1)/2);
	K = 10*ones(1,(n-1)/2);
	K(1) = 11;
	[Ratio, Remaind] = LONG_DIV(Xnum, Xden);
	C(1,1) = Ratio(1);
	Xnum = Remaind;	
	G = 1/Xden(1);
	Xden = G*Xden;
	Z = roots(Xnum);
	P = roots(Xden);
	[Residues, P, Mult] = PART_FRACT_EXPANSION(G, Z, P);
	if P(1) == 0
		L(1)= Residues(1);
	end
	m = 2;
	for n = 2:2:length(Residues)
		a(m) = 2*Residues(n);
		w(m) = P(n);
		C(m) = a(m)/imag(w(m))^2;
		L(m) = 1/a(m);
		m = m+1;
	end
